﻿ #SMP SynthDriver 2012 Tyler Spivey and Patrick Falishevsky <tspivey@pcdesk.net>
PORT="com3"
import threading
import Queue
import synthDriverHandler
from synthDriverHandler import SynthDriver
import speech
import serial
import logging
lastindex = 0
minRate = 0
maxRate = 9
minPitch = 0
maxPitch = 15
minVolume=0
maxVolume=15

#This can't terminate...
class IndexingThread(threading.Thread):
 def run(self):
  global lastindex
  while True:
   byte = port.read(1)
   lastindex = ord(byte)

def clear_queue(q):
 try:
  while True:
   q.get_nowait()
 except:
  pass

port = None
serialQueue = Queue.Queue()
class BgThread(threading.Thread):
 def __init__(self, q):
  threading.Thread.__init__(self)
  self.setDaemon(True)
  self.q = q

 def run(self):
  try:
   while True:
    func, args, kwargs = self.q.get()
    if not func:
     break
    func(*args, **kwargs)
    self.q.task_done()
  except:
   logging.error("bgThread.run", exc_info=True)

def _bgExec(q, func, *args, **kwargs):
 q.put((func, args, kwargs))

def bgWrite(text):
 #timeout errors. Ignore all errors for now, fix later to ignore the specific error
 try:
  port.write(text)
 except:
  pass


class SynthDriver(SynthDriver):
 name = "apollo"
 description = "niby apollo"
 supportedSettings = (SynthDriver.RateSetting(10),SynthDriver.PitchSetting(2),SynthDriver.VolumeSetting(2))

 @classmethod
 def check(cls):
  return True

 def __init__(self):
  global port
  port = serial.serial_for_url(PORT, 9600)
  port.setDsrDtr(0)
  self.serialThread = BgThread(serialQueue)
  self.serialThread.start()
  self.indexingThread = IndexingThread()
  self.indexingThread.start()
  self.dt_rate = 7
  self.dt_pitch = 3
  self.dt_volume = 5

 def speak(self, speechSequence):
  text_list = []
  for item in speechSequence:
   if isinstance(item, basestring):
    text_list.append(item)
   #elif isinstance(item,speech.IndexCommand):
   # text_list.append("\x00%di" % item.index)
  #No unicode here. Do something better with this later
  text = u" ".join(text_list).replace('@', ' ').encode('1250', 'replace')
#  text = text.replace('\r', ' ')
#  text = text.replace('\n', ' ')
  text = text.replace(chr(0xB9), chr(0x86))#ą
  text = text.replace(chr(0xE6), chr(0x8D))#ć
  text = text.replace(chr(0xEA), chr(0x91))#ę
  text = text.replace(chr(0xB3), chr(0x92))#ł
  text = text.replace(chr(0xF1), chr(0xA4))#ń
  text = text.replace(chr(0xF3), chr(0xA2))#ó
  text = text.replace(chr(0x9C), chr(0x9E))#ś
  text = text.replace(chr(0x9F), chr(0xA6))#ź
  text = text.replace(chr(0xBF), chr(0xA7))#ż
  text = text.replace(chr(0xC6), chr(0x95))#Ć
  text = text.replace(chr(0xCA), chr(0x90))#Ę
  text = text.replace(chr(0xA3), chr(0x9C))#Ł
  text = text.replace(chr(0xD3), chr(0xA3))#Ó
  text = text.replace(chr(0x8C), chr(0x98))#Ś
  text = text.replace(chr(0x8F), chr(0xA0))#Ź
  text = text.replace(chr(0xAF), chr(0xA1))#Ż
  text = text.replace(chr(0xA5), chr(0x8F))#Ą
  text = text.replace(chr(0xD1), chr(0xA5))#Ń
  if self.dt_pitch<=9:
   my_dt_pitch=str(self.dt_pitch)
  if self.dt_pitch==10:
   my_dt_pitch="A"
  if self.dt_pitch==11:
   my_dt_pitch="B"
  if self.dt_pitch==12:
   my_dt_pitch="C"
  if self.dt_pitch==13:
   my_dt_pitch="D"
  if self.dt_pitch==14:
   my_dt_pitch="E"
  if self.dt_pitch==15:
   my_dt_pitch="F"
  if self.dt_volume<=9:
   my_dt_volume=str(self.dt_volume)
  if self.dt_volume==10:
   my_dt_volume="A"
  if self.dt_volume==11:
   my_dt_volume="B"
  if self.dt_volume==12:
   my_dt_volume="C"
  if self.dt_volume==13:
   my_dt_volume="D"
  if self.dt_volume==14:
   my_dt_volume="E"
  if self.dt_volume==15:
   my_dt_volume="F"
  text = "@w%s @f%s @a%s %s" % (self.dt_rate, my_dt_pitch, my_dt_volume, text)
  if text:
   _bgExec(serialQueue, bgWrite, text+'\r')

 def cancel(self):
  clear_queue(serialQueue)
  try:
   port.write('\x18')
#   port.write("@i?")
#   port.write(str(lastindex))
  except serial.SerialTimeoutException:
   pass

 def _set_rate(self, vl):
  self.dt_rate = self._percentToParam(vl,minRate,maxRate)

 def _get_rate(self):
  return self._paramToPercent(self.dt_rate, minRate, maxRate)

 def _set_pitch(self, vl):
  self.dt_pitch = self._percentToParam(vl, minPitch, maxPitch)

 def _get_pitch(self):
  return self._paramToPercent(self.dt_pitch, minPitch, maxPitch)

 def _set_volume(self, vl):
  self.dt_volume = self._percentToParam(vl,minVolume,maxVolume)

 def _get_volume(self):
  return self._paramToPercent(self.dt_volume, minVolume, maxVolume)

 def terminate(self):
  serialQueue.put((None, None, None))
  port.close()

 def _get_lastIndex(self):
  return int(62)#lastindex
